Scriptname _SLSubmitBoundEndEffect extends activemagiceffect  

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitFunctions Property _SLFunctions Auto
_SLSubmitQuest Property _SLQuest Auto
_SLSubmitScene Property _SLScene Auto
GlobalVariable Property HardcoreBindings Auto
GlobalVariable Property _SLSubmitBeatenGlobal Auto
ReferenceAlias Property ActorFollower  Auto  
Spell Property _SLSubmitBully Auto
Armor Property _SLSubmitCuffs Auto
Actor Property PlayerRef Auto

Event OnEffectStart(actor target, actor caster)
	Debug.SendAnimationEvent(Target, "IdleHandsBehindBack")
	
	If (ActorFollower.GetActorRef() != none)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "IdleHandsBehindBack")
	EndIf
	
	_SLSubmitBeatenGlobal.SetValue(0)
	_SLFunctions.SetCaptured(false)
	
	If (!_SLConfig.HardcoreActive)
		If (_SLConfig.debugActive)
			debug.Notification("You have worked free of your bindings!")
		EndIf
		Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
		_SLFunctions.DoFadeIn()
		Game.EnablePlayerControls()
		_SLFunctions.SetAnimating(PlayerRef, false)
		If (ActorFollower.GetActorRef() != none)
			Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "IdleForceDefaultState")
			_SLFunctions.SetAnimating(ActorFollower.GetActorRef(), false)
			ActorFollower.Clear()
		EndIf
		_SLScene.WRT(3.0)
		PlayerRef.DispelSpell(_SLSubmitBully)
	Else
		Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
		Target.AddItem(_SLSubmitCuffs,1,true)
		Target.EquipItem(_SLSubmitCuffs,true,true)
		HardcoreBindings.SetValue(1)
		If (ActorFollower.GetActorRef() != none)
			ActorFollower.GetActorRef().AddItem(_SLSubmitCuffs,1,true)
			ActorFollower.GetActorRef().EquipItem(_SLSubmitCuffs,true,true)
		EndIf
		If (_SLConfig.debugActive)
			debug.Notification("Your wrists are still bound! Find a guard or friendly NPC to assist you!")
		EndIf
		_SLFunctions.DoFadeIn()
		Game.EnablePlayerControls(1,0,1,1,1,0,1)
		If (ActorFollower.GetActorRef() != none)
			Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "IdleForceDefaultState")
			ActorFollower.Clear()
		EndIf
		_SLScene.WRT(3.0)
		PlayerRef.DispelSpell(_SLSubmitBully)
	EndIf
EndEvent
